#include "BaseObject.h"

BaseObject::BaseObject()
{
	m_Rotate = 0;

	m_Position.y = -4;
	m_Position.x = 15;
}

BaseObject::BaseObject(IDObject id)
{
	m_ID = id;
}

BaseObject::~BaseObject()
{
}

void BaseObject::Init()
{
	begin_time = clock();
	m_Status = STATUS::MOVE;

	//Rectangle
	m_Rectangle = new GRectangle[4];
	for (int i = 0; i < 4; i++)
	{
		m_Rectangle[i].width = 0.5;
		m_Rectangle[i].height = 0.5;
	}

	canDown = true;
}

void BaseObject::Update()
{
	if (m_Status != STATUS::STOP)
	{
		if (GIsKeyDown(KEY_DOWN))
		{
			m_Position.y++;
		}
		else
		{
			//sau 0.5s moi di chuyen xuong
			end_time = clock();
			if (1000 * (end_time - begin_time) / CLOCKS_PER_SEC >= 500)
			{
				if (canDown)
					m_Position.y++;
				begin_time = clock();
			}
			canDown = true;
		}

		int left, right;
		if (m_ID == IDObject::I)
		{
			left = 2;
			right = 28;
		}
		else
		{
			left = 1;
			right = 29;
		}
		
		if ((m_Position.x > left && m_Position.x < right) && m_Status != STATUS::COLLIDE)
		{
			if (GIsKeyPress(KEY_SPACE))
			{
				if (m_Rotate == 3)
				{
					m_Rotate = 0;
				}
				else
				{
					m_Rotate++;
				}
			}
		}
	}
}

IDObject BaseObject::getID()
{
	return m_ID;
}